--Query:			Information on flexibility volumes estimated (MW, MWh) under the Best View scenario, starting from current year (when query is run)
--Data Set:			Flexibility
--Organisation:		National Grid Electricity Distribution – DSO
--Date created:		10/08/2023
--Last updated:		03/01/2024

--Comments: The query will not give an exact match to the published HOW_MUCH_HV_Zones.csv
--			Ceiling prices have been manually added to provide better visibility to providers and avoid publishing additional sets of data
--			Query returns data from the year of running query. Can amend this on line 36 as required.

--Amendment 03/01/2024: Converting year to INT on line 36

SELECT FINANCIAL_RESULTS.CMZ_CODE as 'CMZ Code'
	  ,CMZ_INFORMATION.FRIENDLY_NAME as 'Zone name'
	  ,SCENARIO_LOOKUP.RETURN as 'Scenario'
	  ,FINANCIAL_RESULTS.SCENARIO_YEAR as 'Year'
	  ,FINANCIAL_RESULTS.PRODUCT as 'Main flexibility product'
	  ,FINANCIAL_RESULTS.PEAK_MW as 'Peak capacity required [MW]'
	  ,FINANCIAL_RESULTS.AVAILABILITY_ENERGY as 'Estimated availability energy [MWh]' 
	  ,FINANCIAL_RESULTS.UTILISATION_ENERGY as 'Estimated utilisation energy [MWh]'

FROM FINANCIAL_RESULTS

JOIN SCENARIO_LOOKUP
	ON FINANCIAL_RESULTS.SCENARIO = SCENARIO_LOOKUP.LOOKUP

INNER JOIN CMZ_INFORMATION															
	ON FINANCIAL_RESULTS.CMZ_CODE = CMZ_INFORMATION.CMZ_CODE

WHERE
	-- Only zones in procurement
	CMZ_INFORMATION.TRANCHE_STATUS = 'PROCUREMENT'
	-- Only for the Best View scenario
	AND FINANCIAL_RESULTS.SCENARIO like '%Best View%'
	-- Starting from current year
	AND FINANCIAL_RESULTS.SCENARIO_YEAR >= CAST(strftime('%Y', 'now') as int)

ORDER BY
	FINANCIAL_RESULTS.CMZ_CODE,
	FINANCIAL_RESULTS.SCENARIO_YEAR
